* FILE MASTER 29/06/2022

clear all
capture log close

version 16

* $root is the working directory
global root "/replication_CDEF/"
global output "/replication_CDEF/output"
global input_ext "/replication_CDEF/input_ext"
global nexis "/replication_CDEF/nexis/Downloads"

* The files for each wave should be as follows
* $root/Wave 1/
* $root/Wave 2/
* $root/Wave 4/
* $root/Wave 5/
* $root/Wave 6/

* set the delimiter for csv files (it depends on what kind of platform Stata runs)
global DELIMITER ;

sysdir set PERSONAL "/replication_CDEF/ado/"
* Make sure you added the ado files mentioned in the README into the PERSONAL folder
* Install programs available on ssc; this will go into your default PLUS folder
ssc install ivreg2
ssc install estout
ssc install chartab

cd "$output"

set matsize 11000

**************************************
* DATA PROCESSING					 *
**************************************

* CREATE THE MAIN DATASET
do "$root/create_dataset.do"

* CREATE CABINET FILE WITH ELECTIONS VARS
do "$root/elezioni.do"

* EXTRACT A REDUCED DATASET (complete_selected.dta) AND DEFINES VARS FOR REGRESSIONS
do "$root/selection.do"

* ROUNDING PATTERNS (rounding.dta)
do "$root/rounding.do"

* CREATE NEXIS VAR
do "$root/nexis_import.do"

* CREATE DATASETS FOR REFORM ANALYSIS AND CONSISTENCY WITH EXPECTATIONS ON LABOUR SUPPLY
do "$root/reforms.do"

*************************************
* ANALYSIS 							*
*************************************
* In each do-file you can find a note explaining where each figure and table is produced

* DESCRIPTIVE ANALYSIS OVER TIME AND AGE (Figure 2)
do "$root/timepattern.do" 

* MAIN RESULTS (All Figures and Tables not mentioned elsewhere)
* Note: for figures/tables not produced as an external file, see analysis.smcl produced within this do-file
do "$root/analysis.do"

* EVENT STUDY GOOGLE TREND (Figure A.4)
do "$root/ES_GT.do"

* RELATION WITH ACTUAL BEHAVIOR IN FOLLOWING WAVES (Table A.5)
do "$root/analysis_long.do"


